/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashMap;
import jpcsp.filesystems.umdiso.AbstractFileSectorDevice;
import jpcsp.filesystems.umdiso.ISectorDevice;

public class BufferedFileSectorDevice
extends AbstractFileSectorDevice {
    protected RandomAccessFile tocFile;
    protected ISectorDevice sectorDevice;
    protected HashMap<Integer, Integer> toc;
    protected boolean tocDirty;
    protected int nextFreeBufferedSectorNumber;
    protected int numSectors;

    public BufferedFileSectorDevice(RandomAccessFile tocFile, RandomAccessFile fileAccess, ISectorDevice sectorDevice) {
        super(fileAccess);
        this.tocFile = tocFile;
        this.sectorDevice = sectorDevice;
        this.readToc();
    }

    protected void readToc() {
        this.toc = new HashMap();
        this.nextFreeBufferedSectorNumber = 0;
        this.tocDirty = false;
        try {
            this.tocFile.seek(0L);
            long length = this.tocFile.length();
            if (length >= 4L) {
                this.numSectors = this.tocFile.readInt();
                for (long i = 4L; i < length; i += 8L) {
                    int sectorNumber = this.tocFile.readInt();
                    int bufferedSectorNumber = this.tocFile.readInt();
                    this.toc.put(sectorNumber, bufferedSectorNumber);
                    this.nextFreeBufferedSectorNumber = Math.max(this.nextFreeBufferedSectorNumber, bufferedSectorNumber + 1);
                }
            } else if (this.sectorDevice != null) {
                this.numSectors = this.sectorDevice.getNumSectors();
            }
        }
        catch (IOException e) {
            log.error((Object)"readToc", (Throwable)e);
        }
    }

    protected void writeToc() {
        if (this.tocDirty) {
            try {
                this.tocFile.seek(0L);
                this.tocFile.writeInt(this.getNumSectors());
                for (Integer sectorNumber : this.toc.keySet()) {
                    Integer bufferedSectorNumber = this.toc.get(sectorNumber);
                    this.tocFile.writeInt(sectorNumber);
                    this.tocFile.writeInt(bufferedSectorNumber);
                }
                this.tocDirty = false;
            }
            catch (IOException e) {
                log.error((Object)"writeToc", (Throwable)e);
            }
        }
    }

    @Override
    public void readSector(int sectorNumber, byte[] buffer, int offset) throws IOException {
        Integer bufferedSectorNumber = this.toc.get(sectorNumber);
        if (bufferedSectorNumber != null) {
            this.fileAccess.seek(2048L * (long)bufferedSectorNumber.intValue());
            this.fileAccess.read(buffer, offset, 2048);
            return;
        }
        if (this.sectorDevice == null) {
            log.warn((Object)String.format("Reading outside the UMD buffer file (sector=0x%X)", sectorNumber));
            Arrays.fill(buffer, offset, offset + 2048, (byte)0);
        } else {
            this.sectorDevice.readSector(sectorNumber, buffer, offset);
            this.fileAccess.seek(2048L * (long)this.nextFreeBufferedSectorNumber);
            this.fileAccess.write(buffer, offset, 2048);
            this.toc.put(sectorNumber, this.nextFreeBufferedSectorNumber);
            ++this.nextFreeBufferedSectorNumber;
            this.tocDirty = true;
        }
    }

    @Override
    public int getNumSectors() throws IOException {
        return this.numSectors;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.sectorDevice != null) {
            this.sectorDevice.close();
            this.sectorDevice = null;
        }
        this.writeToc();
        this.tocFile.close();
        this.tocFile = null;
        this.toc = null;
    }
}

